/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client;

import com.direwolf20.buildinggadgets.client.KeyBindings;
import com.direwolf20.buildinggadgets.client.cache.CacheTemplateProvider;
import com.direwolf20.buildinggadgets.client.events.EventTooltip;
import com.direwolf20.buildinggadgets.client.models.ConstructionBakedModel;
import com.direwolf20.buildinggadgets.client.screen.TemplateManagerGUI;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlock;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.containers.OurContainers;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ClientProxy {
    public static final CacheTemplateProvider CACHE_TEMPLATE_PROVIDER = new CacheTemplateProvider();

    public static void clientSetup(IEventBus eventBus) {
        KeyBindings.init();
        MinecraftForgeClient.registerTooltipComponentFactory(EventTooltip.CopyPasteTooltipComponent.Data.class, EventTooltip.CopyPasteTooltipComponent::new);
        eventBus.addListener(ClientProxy::bakeModels);
        eventBus.addListener(ClientProxy::registerSprites);
        MinecraftForge.EVENT_BUS.addListener(ClientProxy::onPlayerLoggedOut);
        MenuScreens.m_96206_((MenuType)((MenuType)OurContainers.TEMPLATE_MANAGER_CONTAINER.get()), TemplateManagerGUI::new);
        ((ConstructionBlock)((Object)OurBlocks.CONSTRUCTION_BLOCK.get())).initColorHandler(Minecraft.m_91087_().m_91298_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)OurBlocks.CONSTRUCTION_BLOCK.get()), RenderType2 -> true);
        CACHE_TEMPLATE_PROVIDER.registerUpdateListener(((GadgetCopyPaste)((Object)OurItems.COPY_PASTE_GADGET_ITEM.get())).getRender());
    }

    private static void registerSprites(TextureStitchEvent.Pre event) {
        event.addSprite(new ResourceLocation("buildinggadgets:gui/slot_copy_paste_gadget"));
        event.addSprite(new ResourceLocation("buildinggadgets:gui/slot_template"));
    }

    public static void playSound(SoundEvent sound, float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)pitch));
    }

    private static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        CACHE_TEMPLATE_PROVIDER.clear();
    }

    private static void bakeModels(ModelBakeEvent event) {
        ResourceLocation ConstrName = new ResourceLocation("buildinggadgets", "construction_block");
        final TextureAtlasSprite breakPart = Minecraft.m_91087_().m_91289_().m_110910_(Blocks.f_50069_.m_49966_()).m_6160_();
        ModelResourceLocation ConstrLocation1 = new ModelResourceLocation(ConstrName, "ambient_occlusion=false,bright=false,neighbor_brightness=false");
        ModelResourceLocation ConstrLocation1a = new ModelResourceLocation(ConstrName, "ambient_occlusion=true,bright=false,neighbor_brightness=false");
        ModelResourceLocation ConstrLocation2 = new ModelResourceLocation(ConstrName, "ambient_occlusion=false,bright=true,neighbor_brightness=false");
        ModelResourceLocation ConstrLocation2a = new ModelResourceLocation(ConstrName, "ambient_occlusion=true,bright=true,neighbor_brightness=false");
        ModelResourceLocation ConstrLocation3 = new ModelResourceLocation(ConstrName, "ambient_occlusion=false,bright=false,neighbor_brightness=true");
        ModelResourceLocation ConstrLocation3a = new ModelResourceLocation(ConstrName, "ambient_occlusion=true,bright=false,neighbor_brightness=true");
        ModelResourceLocation ConstrLocation4 = new ModelResourceLocation(ConstrName, "ambient_occlusion=false,bright=true,neighbor_brightness=true");
        ModelResourceLocation ConstrLocation4a = new ModelResourceLocation(ConstrName, "ambient_occlusion=true,bright=true,neighbor_brightness=true");
        ConstructionBakedModel constructionBakedModel = new ConstructionBakedModel();
        IDynamicBakedModel bakedModelLoader = new IDynamicBakedModel(){

            public boolean m_7539_() {
                return false;
            }

            public boolean m_7547_() {
                return false;
            }

            public boolean m_7521_() {
                return false;
            }

            public boolean m_7541_() {
                return true;
            }

            public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
                BlockState facadeState = (BlockState)modelData.getData(ConstructionBlockTileEntity.FACADE_STATE);
                RenderType layer = MinecraftForgeClient.getRenderType();
                if (facadeState == null || facadeState == Blocks.f_50016_.m_49966_()) {
                    facadeState = ((Block)OurBlocks.CONSTRUCTION_DENSE_BLOCK.get()).m_49966_();
                }
                if (layer != null && !ItemBlockRenderTypes.canRenderInLayer((BlockState)facadeState, (RenderType)layer)) {
                    return Collections.emptyList();
                }
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(facadeState);
                return model.m_6840_(facadeState, side, rand);
            }

            public TextureAtlasSprite m_6160_() {
                return breakPart;
            }

            public ItemOverrides m_7343_() {
                return null;
            }

            @Nonnull
            public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
                return tileData;
            }
        };
        IDynamicBakedModel bakedModelLoaderAmbient = new IDynamicBakedModel(){

            public boolean m_7539_() {
                return false;
            }

            public boolean m_7547_() {
                return false;
            }

            public boolean m_7521_() {
                return false;
            }

            public boolean m_7541_() {
                return true;
            }

            public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
                BlockState facadeState = (BlockState)modelData.getData(ConstructionBlockTileEntity.FACADE_STATE);
                RenderType layer = MinecraftForgeClient.getRenderType();
                if (facadeState == null || facadeState == Blocks.f_50016_.m_49966_()) {
                    facadeState = ((Block)OurBlocks.CONSTRUCTION_DENSE_BLOCK.get()).m_49966_();
                }
                if (layer != null && !ItemBlockRenderTypes.canRenderInLayer((BlockState)facadeState, (RenderType)layer)) {
                    return Collections.emptyList();
                }
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(facadeState);
                return model.m_6840_(facadeState, side, rand);
            }

            public TextureAtlasSprite m_6160_() {
                return breakPart;
            }

            public ItemOverrides m_7343_() {
                return null;
            }

            @Nonnull
            public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
                return tileData;
            }
        };
        event.getModelRegistry().put(ConstrLocation1, bakedModelLoader);
        event.getModelRegistry().put(ConstrLocation2, bakedModelLoader);
        event.getModelRegistry().put(ConstrLocation3, bakedModelLoader);
        event.getModelRegistry().put(ConstrLocation4, bakedModelLoader);
        event.getModelRegistry().put(ConstrLocation1a, bakedModelLoaderAmbient);
        event.getModelRegistry().put(ConstrLocation2a, bakedModelLoaderAmbient);
        event.getModelRegistry().put(ConstrLocation3a, bakedModelLoaderAmbient);
        event.getModelRegistry().put(ConstrLocation4a, bakedModelLoaderAmbient);
    }
}

